﻿//////////////////////////////////////////////
// PrimitiveTopology.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Standards --------------------------------

// nkGraphics
#include "../../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

/// Class ------------------------------------

namespace nkGraphics
{
	enum class PRIMITIVE_TOPOLOGY
	{
		PRIMITIVE_TOPOLOGY_UNDEFINED   = 0,
		POINTLIST                      = 1,
		LINELIST                       = 2,
		LINESTRIP                      = 3,
		TRIANGLELIST                   = 4,
		TRIANGLESTRIP                  = 5,
		LINELIST_ADJ                   = 10,
		LINESTRIP_ADJ                  = 11,
		TRIANGLELIST_ADJ               = 12,
		TRIANGLESTRIP_ADJ              = 13,
		PATCHLIST_1_CONTROL_POINT      = 33,
		PATCHLIST_2_CONTROL_POINT      = 34,
		PATCHLIST_3_CONTROL_POINT      = 35,
		PATCHLIST_4_CONTROL_POINT      = 36,
		PATCHLIST_5_CONTROL_POINT      = 37,
		PATCHLIST_6_CONTROL_POINT      = 38,
		PATCHLIST_7_CONTROL_POINT      = 39,
		PATCHLIST_8_CONTROL_POINT      = 40,
		PATCHLIST_9_CONTROL_POINT      = 41,
		PATCHLIST_10_CONTROL_POINT     = 42,
		PATCHLIST_11_CONTROL_POINT     = 43,
		PATCHLIST_12_CONTROL_POINT     = 44,
		PATCHLIST_13_CONTROL_POINT     = 45,
		PATCHLIST_14_CONTROL_POINT     = 46,
		PATCHLIST_15_CONTROL_POINT     = 47,
		PATCHLIST_16_CONTROL_POINT     = 48,
		PATCHLIST_17_CONTROL_POINT     = 49,
		PATCHLIST_18_CONTROL_POINT     = 50,
		PATCHLIST_19_CONTROL_POINT     = 51,
		PATCHLIST_20_CONTROL_POINT     = 52,
		PATCHLIST_21_CONTROL_POINT     = 53,
		PATCHLIST_22_CONTROL_POINT     = 54,
		PATCHLIST_23_CONTROL_POINT     = 55,
		PATCHLIST_24_CONTROL_POINT     = 56,
		PATCHLIST_25_CONTROL_POINT     = 57,
		PATCHLIST_26_CONTROL_POINT     = 58,
		PATCHLIST_27_CONTROL_POINT     = 59,
		PATCHLIST_28_CONTROL_POINT     = 60,
		PATCHLIST_29_CONTROL_POINT     = 61,
		PATCHLIST_30_CONTROL_POINT     = 62,
		PATCHLIST_31_CONTROL_POINT     = 63,
		PATCHLIST_32_CONTROL_POINT     = 64
	} ;

	class DLL_GRAPHICS_EXPORT PrimitiveTopologyUtils final
	{
		public :

			// Conversions
			static nkMemory::StringView toString (PRIMITIVE_TOPOLOGY value) ;
	} ;
}